//Ex 4.4 Program Title:To implement Bit Plane slicing of gray scale image
///environment: Scilab 5.5.2
//Toolbox: Image Processing Design 8.3.1-1
//Toolbox: SIVP 0.5.3.2
//Tested on OS: Windows 7 Professional, 64 bit
//Reference books names : 1)Digital Image Processing book author :
// Rafael C.Gonzalez and Richard E.Woods,
//2)Digital Image Processing book author :S.Sudhir,
//3)Digital Image Processing book author :Dhanajay Theckedath
clc //to clear command window.
clear all //to disable previously defined variables.
xdel(winsid());///clear all the previous figures plots
SIVP_PATH = getSIVPpath(); //to locate a directory in which SIVP toolbox is installed
i1=imread(SIVP_PATH + 'images/rose.bmp');//read color image from diractory
i2=rgb2gray(i1);//Color to grey scale image
i3=double(i2);
b1=modulo(i3,2);//remainder of image pixels at 1st division
b2=modulo(floor(i3/2),2);
b3=modulo(floor(i3/4),2);
b4=modulo(floor(i3/8),2);
b5=modulo(floor(i3/16),2);
b6=modulo(floor(i3/32),2);
b7=modulo(floor(i3/64),2);
b8=modulo(floor(i3/128),2);
figure(1);ShowImage(i2,'Greyscale image');title('Greyscale image','color','red','fontsize',6);//IPD tool box
figure(2);ShowImage(b1,'Bit plane 1 LSB');title('Bit plane 1 LSB','color','red','fontsize',6);//IPD tool box
figure(3);ShowImage(b2,'Bit plane 2');title('Bit plane 2','color','red','fontsize',6);//IPD tool box
figure(4);ShowImage(b3,'Bit plane 3');title('Bit plane 3','color','red','fontsize',6);//IPD tool box
figure(5);ShowImage(b4,'Bit plane 4');title('Bit plane 4','color','red','fontsize',6);//IPD tool box
figure(6);ShowImage(b5,'Bit plane 5');title('Bit plane 5','color','red','fontsize',6);//IPD tool box
figure(7);ShowImage(b6,'Bit plane 6');title('Bit plane 6','color','red','fontsize',6);//IPD tool box
figure(8);ShowImage(b7,'Bit plane 7');title('Bit plane 7','color','red','fontsize',6);//IPD tool box
figure(9);ShowImage(b8,'Bit plane 8 MSB');title('Bit plane 8 MSB','color','red','fontsize',6);//IPD tool box

